/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;

public class GoToPotentialJobSite
extends Behavior<Villager> {
    private static final int TICKS_UNTIL_TIMEOUT = 1200;
    final float speedModifier;

    public GoToPotentialJobSite(float p_23098_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.POTENTIAL_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
        this.speedModifier = p_23098_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_23103_, Villager p_23104_) {
        return p_23104_.getBrain().getActiveNonCoreActivity().map(p_23115_ -> p_23115_ == Activity.IDLE || p_23115_ == Activity.WORK || p_23115_ == Activity.PLAY).orElse(true);
    }

    @Override
    protected boolean canStillUse(ServerLevel p_23106_, Villager p_23107_, long p_23108_) {
        return p_23107_.getBrain().hasMemoryValue(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected void tick(ServerLevel p_23121_, Villager p_23122_, long p_23123_) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)p_23122_, p_23122_.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get().pos(), this.speedModifier, 1);
    }

    @Override
    protected void stop(ServerLevel p_23129_, Villager p_23130_, long p_23131_) {
        Optional<GlobalPos> $$3 = p_23130_.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
        $$3.ifPresent(p_23111_ -> {
            BlockPos $$2 = p_23111_.pos();
            ServerLevel $$3 = p_23129_.getServer().getLevel(p_23111_.dimension());
            if ($$3 == null) {
                return;
            }
            PoiManager $$4 = $$3.getPoiManager();
            if ($$4.exists($$2, p_217230_ -> true)) {
                $$4.release($$2);
            }
            DebugPackets.sendPoiTicketCountPacket(p_23129_, $$2);
        });
        p_23130_.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Villager)livingEntity, l);
    }
}

